<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\APIPlatformBridgeBundle\Filter;

use DateTimeImmutable;
use Exception;
use XCart\Bundle\LogicBundle\DTO\Request\Filter\Value\DateTimeRangeValue;
use XCart\Bundle\LogicBundle\DTO\Request\Filter\Value\FilterValueInterface;
use XCart\Bundle\LogicBundle\DTO\Request\Filter\Value\Range\DateTimeRange;
use XCart\Bundle\LogicBundle\Enum\FilterStrategy\FilterStrategyInterface;
use XCart\Bundle\LogicBundle\Enum\FilterStrategy\RangeFilterStrategyType;

class DateTimeRangeFilter extends AbstractTypedRangeFilter
{
    protected function buildDeclaration(string $name, string $id): array
    {
        $result = parent::buildDeclaration($name, $id);

        $result['schema']['properties']['begin']['format'] = 'date-time';
        $result['schema']['properties']['end']['format']   = 'date-time';

        return $result;
    }

    /**
     * @param int[]                   $value
     * @param RangeFilterStrategyType $strategy
     * @param bool                    $exclude
     *
     * @return DateTimeRangeValue
     * @throws Exception
     */
    protected function cast(mixed $value, FilterStrategyInterface $strategy, bool $exclude): FilterValueInterface
    {
        $rangeValue = (new DateTimeRange())
            ->setBegin($value['begin'] ? new DateTimeImmutable($value['begin']) : null)
            ->setEnd($value['end'] ? new DateTimeImmutable($value['end']) : null);

        return (new DateTimeRangeValue())
            ->setValue($rangeValue)
            ->setStrategy($strategy)
            ->setExclude($exclude);
    }

    protected function getType(): string
    {
        return 'string';
    }
}
