<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\APIPlatformBridgeBundle\Filter;

use DateTimeImmutable;
use Exception;
use XCart\Bundle\LogicBundle\DTO\Request\Filter\Value\FilterValueInterface;
use XCart\Bundle\LogicBundle\DTO\Request\Filter\Value\DateTimeListValue;
use XCart\Bundle\LogicBundle\Enum\FilterStrategy\FilterStrategyInterface;
use XCart\Bundle\LogicBundle\Enum\FilterStrategy\ListFilterStrategyType;

class DateTimeListFilter extends AbstractTypedListFilter
{
    protected function buildDeclaration(string $name, string $id): array
    {
        $result = parent::buildDeclaration($name, $id);

        $result['schema']['items']['format'] = 'date-time';

        return $result;
    }

    /**
     * @param string[]               $value
     * @param ListFilterStrategyType $strategy
     * @param bool                   $exclude
     *
     * @return DateTimeListValue
     * @throws Exception
     */
    protected function cast(mixed $value, FilterStrategyInterface $strategy, bool $exclude): FilterValueInterface
    {
        return (new DateTimeListValue())
            ->setValue(array_map(static fn ($item) => new DateTimeImmutable($item), $value))
            ->setStrategy($strategy)
            ->setExclude($exclude);
    }

    protected function getType(): string
    {
        return 'string';
    }
}
