<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\APIPlatformBridgeBundle\Filter;

abstract class AbstractTypedFilter extends AbstractFilter
{
    protected const KEY_TEMPLATE          = 'filter.%s';
    protected const KEY_STRATEGY_TEMPLATE = 'filter.%s.strategy';
    protected const KEY_EXCLUDE_TEMPLATE  = 'filter.%s.exclude';

    protected function buildDeclaration(string $name, string $id): array
    {
        return [
            'property'    => $id,
            'type'        => $this->getType(),
            'required'    => $this->required,
            'description' => sprintf('Filter for "%s" field', $name),
            'schema'      => [
                'name' => $id,
                'type' => $this->getSwaggerType(),
            ],
        ];
    }

    protected function buildStrategyDeclaration(string $name, string $id, array $strategies): array
    {
        return [
            'property'    => $id,
            'type'        => 'string',
            'required'    => false,
            'description' => sprintf('Filter strategy for "%s" field', $name),
            'schema'      => [
                'name' => $id,
                'type' => 'string',
                'enum' => $strategies,
            ],
        ];
    }

    protected function buildExcludeDeclaration(string $name, string $id): array
    {
        return [
            'property'    => $id,
            'type'        => 'boolean',
            'required'    => false,
            'description' => sprintf('Filter exclude flag for "%s" field', $name),
            'schema'      => [
                'name'    => $id,
                'type'    => 'boolean',
                'default' => false,
            ],
        ];
    }
}
