<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\APIPlatformBridgeBundle\Extension;

use XCart\Bundle\LogicBundle\DTO\Request\PaginatorRequestInterface;

class PaginationExtension implements PaginationExtensionInterface
{
    public function enrich(PaginatorRequestInterface $request, string $resourceClass, string $operationName, array $context = []): void
    {
        if (isset($context['page'])) {
            $request->setPageIndex((int) $context['page']);
        }

        if (isset($context['itemsPerPage'])) {
            $request->setItemsPerPage((int) $context['itemsPerPage']);

            if (!isset($context['page'])) {
                $request->setPageIndex(1);
            }
        }
    }
}
