<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\APIPlatformBridgeBundle\Extension;

use ApiPlatform\Core\Metadata\Resource\Factory\ResourceMetadataFactoryInterface;
use ApiPlatform\Exception\ResourceClassNotFoundException;
use Psr\Container\ContainerInterface;
use Throwable;
use XCart\Bundle\LogicBundle\DTO\Request\OrderRule\OrderRuleInterface as RequestFilterInterface;
use XCart\Bundle\APIPlatformBridgeBundle\OrderRule\OrderRuleInterface;

class OrderRuleExtension implements OrderRuleExtensionInterface
{
    public function __construct(
        private ContainerInterface $filterLocator,
        private ResourceMetadataFactoryInterface $resourceMetadataFactory,
    ) {
    }

    public function enrich(RequestFilterInterface $request, string $resourceClass, string $operationName, array $context = []): void
    {
        try {
            $resourceFilters = $this->resourceMetadataFactory
                ->create($resourceClass)
                ->getCollectionOperationAttribute($operationName, 'filters', [], true);
        } catch (ResourceClassNotFoundException) {
            return;
        }

        if (empty($resourceFilters)) {
            return;
        }

        foreach ($resourceFilters as $filterId) {
            if (!$this->filterLocator->has($filterId)) {
                continue;
            }

            try {
                $filter = $this->filterLocator->get($filterId);
            } catch (Throwable) {
                continue;
            }
            if (!($filter instanceof OrderRuleInterface)) {
                continue;
            }

            $context['filters'] = $context['filters'] ?? [];
            $filter->enrich($request, $resourceClass, $operationName, $context);
        }
    }
}
