<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Bundle\APIPlatformBridgeBundle\DTO;

use ApiPlatform\State\Pagination\PaginatorInterface;

class CollectionPaginator implements \IteratorAggregate, PaginatorInterface
{
    public function __construct(
        private array $items,
        private int $pageIndex,
        private int $totalItems,
        private int $pageSize,
    ) {
    }

    public function getIterator(): iterable
    {
        return new \ArrayIterator($this->items);
    }

    public function count(): int
    {
        return count($this->items);
    }

    public function getLastPage(): float
    {
        return $this->totalItems > 0
            ? ceil($this->getTotalItems() / $this->getItemsPerPage())
            : 1.0;
    }

    public function getTotalItems(): float
    {
        return (float)max(0, $this->totalItems);
    }

    public function getCurrentPage(): float
    {
        return $this->totalItems > 0
            ? $this->pageIndex
            : 1.0;
    }

    public function getItemsPerPage(): float
    {
        return max(1, $this->pageSize);
    }
}
