<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\APIPlatformBridgeBundle\API\DataProvider\Item\Assembler;

use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\Factory\Request\RequestFactoryInterface;

class RequestAssembler implements RequestAssemblerInterface
{
    public function __construct(
        private RequestFactoryInterface $requestFactory,
    ) {
    }

    public function assemble($id): RequestInterface
    {
        /** @noinspection PhpUndefinedMethodInspection */
        return $this->requestFactory->create()
            ->setId($id);
    }
}
