<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\APIPlatformBridgeBundle\API\DataProvider\Collection\Enricher\Pagination;

use ApiPlatform\Core\Metadata\Resource\Factory\ResourceMetadataFactoryInterface;
use XCart\Bundle\LogicBundle\DTO\Request\PaginatorRequestInterface;

class PaginationEnricher implements PaginationEnricherInterface
{
    public const PAGE_NAME = 'page';

    public function __construct(
        private ResourceMetadataFactoryInterface $resourceMetadataFactory,
    ) {
    }

    public function enrich(PaginatorRequestInterface $request, array $context): void
    {
        $resourceMetadata = $this->resourceMetadataFactory->create($context['resource_class']);
        $itemsPerPageName = $resourceMetadata->getAttribute('pagination')['items_per_page_parameter_name'];
        $maxItemsPerPage = $resourceMetadata->getAttribute('pagination')['maximum_items_per_page'];

        $page = isset($context['filters'][static::PAGE_NAME])
            ? max(1, (int)$context['filters'][static::PAGE_NAME])
            : 1;

        $request->setPageIndex($page);

        $itemsPerPage = isset($context['filters'][$itemsPerPageName])
            ? min($maxItemsPerPage, (int)$context['filters'][$itemsPerPageName])
            : $maxItemsPerPage;
        $itemsPerPage = max(1, $itemsPerPage);

        $request->setItemsPerPage($itemsPerPage);
    }
}
