<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\APIPlatformBridgeBundle\API\DataProvider\Collection\Assembler;

use XCart\Bundle\APIPlatformBridgeBundle\API\DataProvider\Collection\Assembler\Filter\FilterAssemblerInterface;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataProvider\Collection\Assembler\OrderRule\OrderRuleAssemblerInterface;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataProvider\Collection\Enricher\Pagination\PaginationEnricherInterface;
use XCart\Bundle\LogicBundle\DTO\Request\FilterOwnerRequestInterface;
use XCart\Bundle\LogicBundle\DTO\Request\OrderRuleOwnerRequestInterface;
use XCart\Bundle\LogicBundle\DTO\Request\PaginatorRequestInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\Factory\Request\RequestFactoryInterface;

class RequestAssembler implements RequestAssemblerInterface
{
    public function __construct(
        private RequestFactoryInterface $requestFactory,
        private PaginationEnricherInterface $paginationEnricher,
        private ?FilterAssemblerInterface $filterAssembler,
        private ?OrderRuleAssemblerInterface $orderRuleAssembler,
    ) {
    }

    public function assemble(string $resourceClass, string $operationName, array $context): RequestInterface
    {
        $request = $this->requestFactory->create();

        if ($request instanceof PaginatorRequestInterface) {
            $this->paginationEnricher->enrich($request, $context);
        }

        if ($request instanceof FilterOwnerRequestInterface && $this->filterAssembler) {
            $request->setFilter($this->filterAssembler->assemble($resourceClass, $operationName, $context));
        }

        if ($request instanceof OrderRuleOwnerRequestInterface && $this->orderRuleAssembler) {
            $request->setOrderRule($this->orderRuleAssembler->assemble($resourceClass, $operationName, $context));
        }

        return $request;
    }
}
