<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\APIPlatformBridgeBundle\API\DataProvider\Collection\Assembler;

use XCart\Bundle\CommonBundle\Transformer\GeneratedTransparentTransformerInterface;
use XCart\Bundle\LogicBundle\DTO\Response\PayloadListOwnerResponseInterface;

class PayloadResponseAssembler implements ResponseAssemblerInterface
{
    public function __construct(
        private GeneratedTransparentTransformerInterface $transformer,
    ) {
    }

    public function assemble(PayloadListOwnerResponseInterface $response): array
    {
        $result = [];
        foreach ($response->getPayload() as $logicEntity) {
            $result[] = $this->transformer->transform($logicEntity);
        }

        return $result;
    }
}
