<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\APIPlatformBridgeBundle\API\DataProvider\Collection\Assembler\OrderRule;

use XCart\Bundle\APIPlatformBridgeBundle\Extension\OrderRuleExtensionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\OrderRule\OrderRuleInterface;
use XCart\Bundle\LogicBundle\Factory\Request\OrderRuleFactoryInterface;

class OrderRuleAssembler implements OrderRuleAssemblerInterface
{
    public function __construct(
        private OrderRuleFactoryInterface $factory,
        private OrderRuleExtensionInterface $extension,
    ) {
    }

    public function assemble(string $resourceClass, string $operationName, array $context): OrderRuleInterface
    {
        $filter = $this->factory->create();
        $this->extension->enrich($filter, $resourceClass, $operationName, $context);

        return $filter;
    }
}
