<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\APIPlatformBridgeBundle\API\DataProvider\Collection\Assembler\Filter;

use XCart\Bundle\APIPlatformBridgeBundle\Extension\FilterExtensionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\Filter\FilterInterface;
use XCart\Bundle\LogicBundle\Factory\Request\FilterFactoryInterface;

class FilterAssembler implements FilterAssemblerInterface
{
    public function __construct(
        private FilterFactoryInterface $filterFactory,
        private FilterExtensionInterface $filterExtension,
    ) {
    }

    public function assemble(string $resourceClass, string $operationName, array $context): FilterInterface
    {
        $filter = $this->filterFactory->create();
        $this->filterExtension->enrich($filter, $resourceClass, $operationName, $context);

        return $filter;
    }
}
