<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\APIPlatformBridgeBundle\API\DataPersister\Remover;

use ApiPlatform\Exception\ItemNotFoundException;
use ApiPlatform\Exception\OperationNotFoundException;
use ApiPlatform\Exception\RuntimeException;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\BadRequestHttpException;
use Symfony\Component\HttpKernel\Exception\UnauthorizedHttpException;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataPersister\Remover\Assembler\RequestAssemblerInterface;
use XCart\Bundle\APIPlatformBridgeBundle\API\Entity\EntityInterface;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Response\DefaultFailedResponse;

class Remover implements RemoverInterface
{
    public function __construct(
        private ActionInterface $action,
        private RequestAssemblerInterface $requestAssembler,
    ) {
    }

    public function remove(EntityInterface $data, array $context): void
    {
        /** @noinspection PhpParamsInspection */
        $request = $this->requestAssembler->assemble($data);
        $response = $this->action->run($request);
        if ($response instanceof DefaultFailedResponse) {
            throw match ($response->getStatus()) {
                Response::HTTP_BAD_REQUEST        => new BadRequestHttpException($response->getTitle()),
                Response::HTTP_UNAUTHORIZED       => new UnauthorizedHttpException($response->getTitle()),
                Response::HTTP_NOT_FOUND          => new ItemNotFoundException($response->getTitle()),
                Response::HTTP_METHOD_NOT_ALLOWED => new OperationNotFoundException($response->getTitle()),
                default                           => new RuntimeException($response->getTitle()),
            };
        }
    }
}
