<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\APIPlatformBridgeBundle\API\DataPersister\Remover\Assembler;

use XCart\Bundle\CommonBundle\DTO\Id\IdOwnerInterface;
use XCart\Bundle\CommonBundle\Factory\GeneratedFactoryInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;

class IdBasedAssembler implements RequestAssemblerInterface
{
    public function __construct(
        private GeneratedFactoryInterface $factory,
    ) {
    }

    public function assemble(IdOwnerInterface $entity): RequestInterface
    {
        return $this->factory->create()
            ->setId($entity->getId());
    }
}
