<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Bundle\APIPlatformBridgeBundle\API\DataPersister;

use ApiPlatform\Core\DataPersister\ContextAwareDataPersisterInterface;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataPersister\Persister\PersisterInterface;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataPersister\Remover\RemoverInterface;

/**
 * @property string[] $classes
 */
class DataPersister implements ContextAwareDataPersisterInterface
{
    public function __construct(
        private array $classes,
        private ?PersisterInterface $persister,
        private ?RemoverInterface $remover,
    ) {
    }

    public function supports($data, array $context = []): bool
    {
        return in_array(get_class($data), $this->classes, true);
    }

    public function persist($data, array $context = []): object
    {
        return $this->persister->persist($data, $context);
    }

    public function remove($data, array $context = []): void
    {
        $this->remover->remove($data, $context);
    }
}
