# Changelog

## 3.0.0

* Support for [the Web Ontology Language (OWL)](https://en.wikipedia.org/wiki/Web_Ontology_Language) (including for [the ActivityStream vocabulary](https://www.w3.org/TR/activitystreams-core/))
* Support for [XML Schema](https://en.wikipedia.org/wiki/XML_Schema_(W3C)) types
* Compatbility with the latest version of Schema.org
* Improved PHP type hints generation (including support for typed properties)
* Improved PHPDoc support
* Upgrade to EasyRDF 1 and Doctrine Inflector 2
* More flexible configuration
* The `generate-types` command has been renamed `generate`

## 2.2.2

* Update to Symfony 5
* Fix an issue preventing to install the tool when using Symfony Flex
* Fix a singularization issue with some words such as `sameAs`

## 2.2.1

* Allow `symfony/config` 5.0

## 2.2.0

* Symfony 5 compatibility
* Add support for custom Twig templates
* Add support for operations in API Platform annotations
* Add support for custom `columnPrefix`
* Use superseding props over which they superseded
* Fix implicit and explicit property inheritance
* Use nullable property for custom fields
* Add `inversedBy` and `mappedBy` Doctrine attributes
* Fix annotation generation

## 2.1.0

* Allow to use a PSR-4 namespace's prefix
* Autodetect Flex-like directory structure
* Improve the message when using 1st type in range

## 2.0.2

* Use PHPScoper build the PHAR (to prevent conflicts with libraries installed in the project)
* Add E2E tests

## 2.0.1

* The generator now relies on embedded schema file to prevent issues with online XML files and allow offline usage
* An issue regarding the Inflector namespace has been fixed

## 2.0.0

* Generated classes include scalar typehints and return type
* New options to generate autoincremented IDs, UUIDs, custom IDs or to not generate IDs at all (DTO)
* Nullable typehints are generated instead of a default `null` value
* Add new `readable` and `writable` options to fields to skip getter or mutator generation.
* A fluent interface isn't generated anymore by default unless you set the `fluentMutatorMethods` config flag to `true`
* Useless PHPDoc (`@param` and `@return` annotations when a typehint exist and mutator description) isn't generated anymore
* `DateTimeInterface` is used instead of `DateTime` when possible
* Add the ability to not generate accessor methods (useful when generating public properties)
* The annotation generator for API Platform v1 has been dropped. Only API Platform v2 is now supported
* Parent class is not generated by default anymore (using inheritance for entity is discouraged)
* `SerializerGroupsAnnotationGenerator` is enabled by default
* The property name is pluralized for `to-many` relations and singularized for `to-one` relations
* Adder and remover methods are always singularized to be compatible with the Symfony Property Accessor
* If a config file called `schema.yaml` is found in the current directory and no 2nd argument is passed to `generate-types`, this file will be used
* The code has been modernized to use PHP 7 and 7.1's new features (typehints, strict types), PHP 7.1 is now a requirement
* PHP CS Fixer has ben upgraded to its version 2
* The `extract-cardinalities` gains two new options: one to configure the Schema.org's file to use, the other for the GoodRelations one

## 1.2.0

* The default config now match the Symfony's and API Platform's Best Practices (namespaces)
* The API Platform's annotation generator is enabled by default
* Use HTTPS to retrieve vocabularies by default
* Properties are generated in the order of the config file
* Properties and constants are separated by an empty line

## 1.1.2

* Fix a bug when generating enumerations

## 1.1.1

* Use the new PHP CS Fixer package

## 1.1.0

* MongoDB support
* API Platform Core v2 support
* Schema Generator is now available as PHAR
* Support any RDF vocabulary (was previously limited to Schema.org)
* Support for custom classes
* Support for [Doctrine Embeddables](http://doctrine-orm.readthedocs.io/projects/doctrine-orm/en/latest/tutorials/embeddables.html)
* Support for serialization groups
* Support for the `nullable` option
* Support for the `unique` option
* Support for custom Doctine `@Column` annotations
* Symfony 3.0 compatibility
* Various bug fixes and improved tests

## 1.0.0

* Rename the package API Platform Schema Generator (formerly PHP Schema)
* Support for external and custom RDFa schemas
* Support custom name for relation tables
* Allow to use properties from parent classes
* Allow to create custom fields
* Improve code quality and tests

## 0.4.3

* Fix compatibility with [API Platform Core](https://github.com/api-platform/core) v1 (formerly DunglasJsonLdApiBundle)

## 0.4.2

* Fix compatibility with [API Platform Core](https://github.com/api-platform/core) v1 (formerly DunglasJsonLdApiBundle)

## 0.4.1

* Make CS fixer working again

## 0.4.0

* [API Platform Core](https://github.com/api-platform/core) v1 (formerly DunglasJsonLdApiBundle) support

## 0.3.2

* Fixed Doctrine relations handling
* Better `null` value handling

## 0.3.1

* Fix a bug when using Doctrine `ArrayCollection`
* Don't call `parent::__construct()`` when the parent constructor doesn't exist

## 0.3.0

* Symfony / Doctrine's ResolveTragetEntityListener config mapping generation
* Refactored Doctrine config
* Removed deprecated call to `YAML::parse()``

## 0.2.0

* Better generated PHPDoc
* Removed `@type` support
