<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Tests\XLite\Core;

use PHPUnit\Framework\TestCase;
use Symfony\Bundle\FrameworkBundle\Test\KernelTestCase;
use XLite\Core\Converter;

/**
 * @coversDefaultClass \XLite\Core\Converter
 */
class ConverterTest extends KernelTestCase
{
    protected static string $tz = '';

    public static function setUpBeforeClass(): void
    {
        static::$tz = date_default_timezone_get();

        date_default_timezone_set('UTC');
    }

    public static function tearDownAfterClass(): void
    {
        date_default_timezone_set(static::$tz);
    }

    /**
     * @dataProvider providerConvertArrayToRangeString
     */
    public function testConvertArrayToRangeString(string $expected, array $range): void
    {
        $result = Converter::convertArrayToRangeString($range, 'm/d/Y', ' ~ ');

        $this->assertEquals($expected, $result);
    }

    public function providerConvertArrayToRangeString(): array
    {
        return [
            [
                date('m/d/Y') . ' ~ ' . date('m/d/Y'),
                [0, 0],
            ],
            [
                date('m/d/Y') . ' ~ 09/05/2017',
                [0, 1504569600],
            ],
            [
                '09/01/1939 ~ 09/02/1945',
                [-957312000, -767836800],
            ],
            [
                '01/01/2001 ~ 02/03/2011',
                [978307200, 1296691200],
            ],
        ];
    }
}
