<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Transformer\XLite\Model\Profile\Logic\Entity\Storefront;

use XLite\Model\Profile as Source;
use XCart\Logic\Entity\Storefront\User as Target;
use XCart\Factory\Logic\Entity\Storefront\UserInterface as Factory;
use XLite\Model\Repo\Cart as CartRepository;

class User implements UserInterface
{
    public function __construct(
        private Factory $factory,
        private CartRepository $cartReadRepository,
    ) {
    }

    public function transform(?Source $input): Target
    {
        $target = $this->factory->create();

        $target->setId($input->getProfileId());
        $target->setLogin($input->getLogin());
        $target->setMembership($input->getMembership()?->getName());

        $cart = $this->cartReadRepository->findOneBy(['orig_profile' => $input]);
        if ($cart) {
            $target->setCartId($cart->getPublicId());
        }

        return $target;
    }
}
