<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Transformer\XLite\Model\Profile\Logic\Entity\Storefront;

use XCart\Factory\Logic\Entity\Storefront\PrincipalInterface as Factory;
use XCart\Logic\Entity\Storefront\Principal as Target;
use XLite\Model\Profile as Source;

class Principal implements PrincipalInterface
{
    public function __construct(
        private Factory $factory,
    ) {
    }

    public function transform(?Source $input): Target
    {
        $target  = $this->factory->create();
        $address = $input?->getFirstAddress();

        $roles = array_map(
            static fn ($role) => $role->getPublicName(),
            $input ? $input->getRoles()->toArray() : []
        );

        return $target
            ->setId($input?->getProfileId())
            ->setEmail($input?->getEmail())
            ->setFirstname($address?->getFirstname())
            ->setLastname($address?->getLastname())
            ->setRoles($roles);
    }
}
