<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Transformer\XLite\Model\Profile\Logic\Entity\Storefront;

use XLite\Model\Profile as Source;
use XCart\Logic\Entity\Storefront\NewUser as Target;
use XCart\Factory\Logic\Entity\Storefront\NewUserInterface as Factory;

class NewUser implements NewUserInterface
{
    public function __construct(
        private Factory $factory
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->factory->create();

        $target->setId($input->getProfileId());
        $target->setLogin($input->getLogin());
        $target->setMembership($input->getMembership()?->getName());

        return $target;
    }
}
