<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Transformer\XLite\Model\Payment\Method\Logic\Entity\Storefront\Cart;

use XCart\Factory\Logic\Entity\Storefront\Cart\PaymentMethodInterface as Factory;
use XCart\Logic\Entity\Storefront\Cart\PaymentMethod as Target;
use XLite\Model\Payment\Method as Source;
use XLite\Model\Cart as CartModel;

class PaymentMethod implements PaymentMethodInterface
{
    public function __construct(
        private Factory $factory,
    ) {
    }

    public function transform(Source $input, CartModel $cartInput): Target
    {
        $target = $this->factory->create();

        $target->setId($input->getMethodId());
        $target->setCartId($cartInput->getPublicId());
        $target->setServiceName($input->getServiceName());
        $target->setName($input->getName());
        $target->setTitle($input->getTitle());
        $target->setDescription($input->getDescription());
        $target->setInstruction($input->getInstruction());

        return $target;
    }
}
