<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Transformer\XLite\Model\OrderItem\Surcharge\Logic\Entity\Storefront\Cart\Item;

use XLite\Model\OrderItem\Surcharge as Source;
use XCart\Logic\Entity\Storefront\Cart\Item\Surcharge as Target;

class Surcharge implements SurchargeInterface
{
    public function transform(Source $input): Target
    {
        $target = new Target();
        $target->setName($input->getName());
        $target->setValue($input->getValue());
        $target->setType($input->getType());

        return $target;
    }
}
