<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Transformer\XLite\Model\OrderItem\Logic\Entity\Storefront\Cart;

use XCart\Factory\Logic\Entity\Storefront\Cart\NewItemInterface as Factory;
use XCart\Logic\Entity\Storefront\Cart\NewItem as Target;
use XCart\Logic\Entity\Storefront\Image;
use XCart\Transformer\XLite\Model\OrderItem\AttributeValue\Logic\Entity\Storefront\Cart\Item\AttributeValueInterface;
use XCart\Transformer\XLite\Model\OrderItem\Surcharge\Logic\Entity\Storefront\Cart\Item\SurchargeInterface;
use XLite\Model\OrderItem as Source;

class NewItem implements NewItemInterface
{
    public function __construct(
        private Factory $factory,
        private SurchargeInterface $surchargeTransformer,
        private AttributeValueInterface $attributeValueTransformer,
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->factory->create();

        $target->setId($input->getId());
        $target->setSku($input->getSku());
        $target->setName($input->getName());
        $target->setCleanURL($input->getProduct()?->getCleanURL());
        $target->setAmount($input->getAmount());
        $target->setPrice($input->getPrice());
        $target->setClearPrice($input->getClearPrice());
        $target->setNetPrice($input->getNetPrice());
        $target->setDisplayPrice($input->getDisplayPrice());
        $target->setAmount($input->getAmount());
        $target->setInStock($input->getProduct()?->getAmount());
        $target->setProductId($input->getProductId());
        $target->setSubtotal($input->getSubtotal());
        $target->setTotal($input->getTotal());
        $target->setCartId($input->getOrder()->getOrderId());

        $surcharges = [];
        foreach ($input->getSurcharges() as $surcharge) {
            $surcharges[] = $this->surchargeTransformer->transform($surcharge);
        }
        $target->setSurcharges($surcharges);

        $attributes = [];
        foreach ($input->getAttributeValues() as $attribute) {
            $attributes[] = $this->attributeValueTransformer->transform($attribute);
        }
        $target->setAttributes($attributes);

        $target->setImages($this->getTransformedImages($input));

        return $target;
    }

    /**
     * @return Image[]
     */
    private function getTransformedImages(Source $input): array
    {
        $transformedImages = [];

        /* @var \XLite\Model\Image\Product\Image $image */
        foreach ($input->getProduct()->getImages()->toArray() as $inputImage) {
            $transformedImages[] = (new Image())
                ->setUrl($inputImage->getFrontURL())
                ->setAlt($inputImage->getAlt())
                ->setWidth($inputImage->getWidth())
                ->setHeight($inputImage->getHeight());
        }

        return $transformedImages;
    }
}
