<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Transformer\XLite\Model\OrderItem\AttributeValue\Logic\Entity\Storefront\Cart\Item;

use XLite\Model\OrderItem\AttributeValue as Source;
use XCart\Logic\Entity\Storefront\Cart\Item\AttributeValue as Target;

class AttributeValue implements AttributeValueInterface
{
    public function transform(Source $input): Target
    {
        $target = new Target();
        $target->setAttributeId($input->getAttributeId());
        $target->setAttributeValueId($input->getAttributeValueId());
        $target->setAttributeValue((string) $input->getActualValue());
        $target->setName($input->getAttributeValue()?->getAttribute()->getName());

        return $target;
    }
}
