<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Transformer\XLite\Model\Country\Logic\Entity\Storefront;

use XCart\Factory\Logic\Entity\Storefront\CountryInterface as Factory;
use XCart\Logic\Entity\Storefront\Country as Target;
use XCart\Logic\Entity\Storefront\Region;
use XCart\Logic\Entity\Storefront\State;
use XLite\Model\Country as Source;

class Country implements CountryInterface
{
    public function __construct(
        private Factory $factory
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->factory->create();

        $target->setId($input->getCode());
        $target->setCode($input->getCode());
        $target->setName($input->getCountry());
        $target->setRegions(
            $this->getTransformedRegions($input)
        );
        $target->setStates(
            $this->getTransformedStates($input)
        );

        return $target;
    }

    /**
     * @return Region[]
     */
    private function getTransformedRegions(Source $input): array
    {
        $result = [];

        /** @var \XLite\Model\Region $region */
        foreach ($input->getRegions() as $region) {
            $result[] = (new Region())
                ->setCode($region->getCode())
                ->setName($region->getName());
        }

        return $result;
    }

    /**
     * @return State[]
     */
    private function getTransformedStates(Source $input): array
    {
        $result = [];

        /** @var \XLite\Model\State $state */
        foreach ($input->getStates() as $state) {
            $result[] = (new State())
                ->setId($state->getStateId())
                ->setCode($state->getCode())
                ->setName($state->getState())
                ->setRegionCode($state->getRegion()?->getCode());
        }

        return $result;
    }
}
