<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Transformer\XLite\Model\Category\Logic\Entity\Storefront;

use XCart\Logic\Entity\Storefront\Image;
use XLite\Model\Category as Source;
use XCart\Logic\Entity\Storefront\Category as Target;
use XCart\Factory\Logic\Entity\Storefront\CategoryInterface as Factory;

class Category implements CategoryInterface
{
    public function __construct(
        private Factory $factory,
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->factory->create();

        $target->setId($input->getId());
        $target->setName($input->getName());
        $target->setDescription($input->getDescription());
        $target->setCleanUrl($input->getCleanUrl());
        $target->setShowTitle($input->getShowTitle());
        $target->setMetaTags($input->getMetaTags());
        $target->setMetaDescription($input->getMetaDesc());
        $target->setMetaTitle($input->getMetaTitle());
        $target->setHasSubcategories($input->hasSubcategories());

        $image = null;
        if ($input->getImage()) {
            $image = (new Image())
                ->setUrl($input->getImage()->getFrontURL())
                ->setAlt($input->getImage()->getAlt())
                ->setWidth($input->getImage()->getWidth())
                ->setHeight($input->getImage()->getHeight());
        }
        $target->setIcon($image);

        $banner = null;
        if ($input->getBanner()) {
            $banner = (new Image())
                ->setUrl($input->getBanner()->getFrontURL())
                ->setAlt($input->getBanner()->getAlt())
                ->setWidth($input->getBanner()->getWidth())
                ->setHeight($input->getBanner()->getHeight());
        }
        $target->setBanner($banner);

        $path = [];
        foreach ($input->getPath() as $parentCategory) {
            $path[] = $this->assemblePathElement($parentCategory);
        }
        $target->setPath($path);

        return $target;
    }

    private function assemblePathElement(Source $parentCategory): Target\PathElement
    {
        return (new Target\PathElement())
            ->setId($parentCategory->getId())
            ->setName($parentCategory->getName())
            ->setCleanUrl($parentCategory->getCleanURL());
    }
}
