<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Transformer\XLite\Model\Cart\Logic\Entity\Storefront;

use XCart\Logic\Entity\Storefront\Cart as Target;
use XCart\Transformer\XLite\Model\Payment\Method\Logic\Entity\Storefront\Cart\PaymentMethodInterface as PaymentMethodTransformer;
use XCart\Transformer\XLite\Model\Order\Surcharge\Logic\Entity\Storefront\Cart\SurchargeInterface as SurchargeTransformer;
use XCart\Transformer\XLite\Model\OrderItem\Logic\Entity\Storefront\Cart\ItemInterface as CartItemTransformer;
use XLite\Model\Cart as Source;
use XCart\Factory\Logic\Entity\Storefront\CartInterface as Factory;

class Cart implements CartInterface
{
    public function __construct(
        private Factory $factory,
        private SurchargeTransformer $surchargeTransformer,
        private CartItemTransformer $itemTransformer,
        private PaymentMethodTransformer $paymentMethodTransformer,
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->factory->create();

        $target->setId($input->getOrderId());
        $target->setPublicId($input->getPublicId());
        $target->setSubTotal($input->getSubtotal());
        $target->setTotal($input->getTotal());
        $target->setEmail($input->getProfile()->getEmail());

        if ($input->getPaymentMethod()) {
            $target->setPayment(
                $this->paymentMethodTransformer->transform($input->getPaymentMethod(), $input)
            );

            $target->setPaymentTransaction($input->getFirstOpenPaymentTransaction()?->getPublicTxnId());
        }

        $surcharges = [];
        foreach ($input->getSurcharges() as $surcharge) {
            $surcharges[] = $this->surchargeTransformer->transform($surcharge);
        }
        $target->setSurcharges($surcharges);

        $items = [];
        foreach ($input->getItems() as $item) {
            $items[] = $this->itemTransformer->transform($item);
        }
        $target->setItems($items);

        return $target;
    }
}
