<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Transformer\XLite\Model\AttributeValue\Logic\Entity\Storefront;

use XLite\Model\AttributeValue\AAttributeValue as Source;
use XLite\Model\Product as ProductSource;
use XCart\Logic\Entity\Storefront\ProductAttributeValue as Target;
use XCart\Factory\Logic\Entity\Storefront\ProductAttributeValueInterface as Factory;

class AttributeValue implements AttributeValueInterface
{
    public function __construct(
        private Factory $factory
    ) {
    }

    public function transform(Source $input, ProductSource $inputProduct): Target
    {
        $target = $this->factory->create();

        $target->setId($input->getId());
        $target->setValue((string) $input->asString());

        if ($input->getAttribute()->isMultiple($inputProduct)) {
            /* @var \XLite\Model\AttributeValue\Multiple $input */
            $target->setIsDefault($input->isDefault());
            $target->setPriceModifier($input->getPriceModifier());
            $target->setPriceModifierType($input->getPriceModifierType());
            $target->setWeightModifier($input->getWeightModifier());
            $target->setWeightModifierType($input->getWeightModifierType());
        }

        return $target;
    }
}
