<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Transformer\XLite\Model\AddressFieldValue\Logic\Entity\Storefront;

use XLite\Model\AddressFieldValue as Source;
use XCart\Logic\Entity\Storefront\AddressFieldValue as Target;
use XCart\Factory\Logic\Entity\Storefront\AddressFieldValueInterface as Factory;

class AddressFieldValue implements AddressFieldValueInterface
{
    public function __construct(private Factory $factory)
    {
    }

    public function transform(Source $input): Target
    {
        $addressField = $input->getAddressField();

        return $this->factory->create()
            ->setServiceName($addressField->getServiceName())
            ->setName($addressField->getName())
            ->setRequired($addressField->getRequired())
            ->setValue((string) $input->getValue());
    }
}
