<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Transformer\XLite\Model\AddressField\Logic\Entity\Storefront;

use XCart\Logic\Entity\Storefront\AddressFieldSelectorOption;
use XLite\Model\AddressField as Source;
use XCart\Logic\Entity\Storefront\AddressField as Target;
use XCart\Factory\Logic\Entity\Storefront\AddressFieldInterface as Factory;

class AddressField implements AddressFieldInterface
{
    public function __construct(private Factory $factory)
    {
    }

    public function transform(Source $input): Target
    {
        $target = $this->factory->create();

        $target->setId($input->getId());
        $target->setServiceName($input->getServiceName());
        $target->setLabel((string) $input->getName());
        $target->setRequired($input->getRequired());

        $target->setValues(
            $this->getTransformedAddressFieldSelectorOptions($input)
        );

        return $target;
    }

    /**
     * @return AddressFieldSelectorOption[]|null
     */
    private function getTransformedAddressFieldSelectorOptions(Source $input): ?array
    {
        $result = null;

        $fieldViewClass  = $input->getSchemaClass();
        $fieldViewObject = new $fieldViewClass();

        if (
            $fieldViewObject instanceof \XLite\View\FormField\Select\ASelect
            && !in_array($input->getServiceName(), ['country_code', 'state_id'], true)
        ) {
            $result = [];

            foreach ($fieldViewObject->getDefaultOptions() as $value => $label) {
                $result[] = (new AddressFieldSelectorOption())
                    ->setValue($value)
                    ->setLabel((string) $label);
            }
        }

        return $result;
    }
}
