<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Transformer\XLite\Model\Address\Logic\Entity\Storefront;

use XCart\Transformer\XLite\Model\AddressFieldValue\Logic\Entity\Storefront\AddressFieldValueInterface as AddressFieldValueTransformer;
use XLite\Model\Address as Source;
use XCart\Logic\Entity\Storefront\Address as Target;
use XCart\Factory\Logic\Entity\Storefront\AddressInterface as Factory;

class Address implements AddressInterface
{
    public function __construct(
        private Factory $factory,
        private AddressFieldValueTransformer $addressFieldValueTransformer,
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->factory->create();

        $target->setId($input->getAddressId());
        $target->setIsBilling($input->getIsBilling());
        $target->setIsShipping($input->getIsShipping());

        $target->setFields(
            array_map(
                fn($fieldValue) => $this->addressFieldValueTransformer->transform($fieldValue),
                $input->getAddressFields()->toArray()
            )
        );

        return $target;
    }
}
