<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Transformer\Logic\Entity\Storefront\NewCart\API\Entity\Storefront;

use JMS\Serializer\SerializerInterface;
use XCart\Logic\Entity\Storefront\NewCart as Source;
use XCart\API\Entity\Storefront\Cart as Target;

class Cart implements CartInterface
{
    private const FORMAT = 'json';

    public function __construct(
        private SerializerInterface $serializer,
    ) {
    }

    public function transform(Source $input): Target
    {
        /** @var target $target */
        $target = $this->serializer->deserialize(
            $this->serializer->serialize($input, static::FORMAT),
            Target::class,
            static::FORMAT
        );
        $target->setId($input->getPublicId());

        return $target;
    }
}
