<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Transformer\Logic\Entity\Storefront\NewAddress\XLite\Model;

use XCart\Bundle\DoctrineBridgeBundle\Repository\ReadRepositoryInterface;
use XCart\Logic\Entity\Storefront\NewAddress as Source;
use XCart\Operation\Service\Storefront\Address\SetAddressFieldsInterface;
use XLite\Model\Address as Target;

class Address implements AddressInterface
{
    public function __construct(
        private ReadRepositoryInterface $profileRepository,
        private SetAddressFieldsInterface $setAddressFields,
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = new Target();

        /** @var \XLite\Model\Profile $profile */
        $profile = $this->profileRepository->find($input->getProfileId());

        $target->setProfile($profile);

        if (!$profile->getBillingAddress()) {
            $target->setIsBilling(true);
        }

        if (!$profile->getShippingAddress()) {
            $target->setIsShipping(true);
        }

        ($this->setAddressFields)($input, $target);

        return $target;
    }
}
