<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Transformer\Logic\Entity\Storefront\Config\API\Entity\Storefront;

use XCart\API\Entity\Storefront\Config as Target;
use XCart\Factory\API\Entity\Storefront\ConfigInterface as Factory;
use XCart\Logic\Entity\Storefront\Config as Source;

class Config implements ConfigInterface
{
    public function __construct(
        private Factory $factory,
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->factory->create();
        $target->setId(
            $this->generateId($input->getName(), $input->getCategory())
        );
        $target->setName($input->getName());
        $target->setCategory($input->getCategory());
        $target->setValue($input->getValue());

        return $target;
    }

    private function generateId(string $name, string $category): string
    {
        return "{$category}-{$name}";
    }
}
