<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Transformer\Logic\Entity\Storefront\Cart\Item\XLite\Model;

use ApiPlatform\Exception\InvalidArgumentException;
use XCart\Logic\Action\Storefront\CartItem\Common\Assembler\ModelAttributeValuesAssemblerInterface;
use XLite\Model\OrderItem as Target;
use XCart\Logic\Entity\Storefront\Cart\Item as Source;
use XLite\Model\Product as ProductModel;
use XLite\Model\Repo\Product as ProductWriteRepository;

class OrderItem implements OrderItemInterface
{
    public function __construct(
        private ProductWriteRepository $productWriteRepository,
        private ModelAttributeValuesAssemblerInterface $attributeValuesAssembler,
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = new Target();

        /** @var ProductModel $product */
        $product = $this->productWriteRepository->find($input->getProductId());
        if (!$product) {
            throw new InvalidArgumentException('Cannot find product');
        }

        $target->setProduct($product);
        $target->setAmount($input->getAmount());
        $target->setPrice($input->getPrice());

        $this->attributeValuesAssembler->assemble($target, $product, $input);

        return $target;
    }
}
