<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Transformer\Event\Payment\BackendTransaction\Logic\Entity\Storefront\Payment\Action;

use XCart\Event\Payment\BackendTransaction as Source;
use XCart\Factory\Logic\Entity\Storefront\Payment\Action\BackendTransaction as TargetFactory;
use XCart\Logic\Entity\Storefront\Payment\Action\BackendTransaction as Target;
use XCart\Transformer\Event\Payment\TransactionData\Logic\Entity\Storefront\Payment\Action\TransactionDataInterface;

final class BackendTransaction implements BackendTransactionInterface
{
    public function __construct(
        private TargetFactory $factory,
        private TransactionDataInterface $transformer
    ) {
    }

    public function transform(Source $input): Target
    {
        return ($this->factory->create())
            ->setStatus($input->getStatus())
            ->setValue($input->getValue())
            ->setType($input->getType())
            ->setData(array_map(fn ($data) => $this->transformer->transform($data), $input->getData()));
    }
}
