<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Transformer\API\Entity\Storefront\Cart\Logic\Entity\Storefront;

use ApiPlatform\Exception\ItemNotFoundException;
use JMS\Serializer\SerializerInterface;
use XCart\API\Entity\Storefront\Cart as Source;
use XCart\Logic\Entity\Storefront\Cart as Target;
use XLite\Model\Repo\Cart as CartReadRepository;

class Cart implements CartInterface
{
    private const FORMAT = 'json';

    public function __construct(
        private CartReadRepository $cartReadRepository,
        private SerializerInterface $serializer,
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->serializer->deserialize(
            $this->serializer->serialize($input, static::FORMAT),
            Target::class,
            static::FORMAT,
        );

        if ($input->getId()) {
            $id = $this->cartReadRepository->getIdByPublicId($input->getId());
            if (!$id) {
                throw new ItemNotFoundException(sprintf('Cannot find item with ID "%s"', $input->getId()));
            }

            $target->setId($id);
        }

        return $target;
    }
}
