<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart;

use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Symfony\Component\Security\Core\Authorization\AuthorizationCheckerInterface;
use Twig\Environment;
use XCart\Doctrine\CallbackManager\CallbackManager;
use XCart\Service\BotDetector\BotDetectorInterface;

class ServiceLocator
{
    public function __construct(
        private Environment $twig,
        private SessionInterface $session,
        private AuthorizationCheckerInterface $authorizationChecker,
        private CallbackManager $callbackManager,
        private BotDetectorInterface $botDetector,
    ) {
    }

    /**
     * @return Environment
     */
    public function getTwig(): Environment
    {
        return $this->twig;
    }

    /**
     * @param Environment $twig
     */
    public function setTwig(Environment $twig): void
    {
        $this->twig = $twig;
    }

    /**
     * @return SessionInterface
     */
    public function getSession(): SessionInterface
    {
        return $this->session;
    }

    /**
     * @param SessionInterface $session
     */
    public function setSession(SessionInterface $session): void
    {
        $this->session = $session;
    }

    public function getAuthorizationChecker(): AuthorizationCheckerInterface
    {
        return $this->authorizationChecker;
    }

    public function setAuthorizationChecker(AuthorizationCheckerInterface $authorizationChecker): void
    {
        $this->authorizationChecker = $authorizationChecker;
    }

    public function getCallbackManager(): CallbackManager
    {
        return $this->callbackManager;
    }

    public function setCallbackManager(CallbackManager $callbackManager): void
    {
        $this->callbackManager = $callbackManager;
    }

    public function setBotDetector(BotDetectorInterface $botDetector): void
    {
        $this->botDetector = $botDetector;
    }

    public function getBotDetector(): BotDetectorInterface
    {
        return $this->botDetector;
    }
}
