<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Service\BotDetector;

interface BotDetectorInterface
{
    /**
     * @param string $headerValue User Agent or other
     */
    public function detectByHeader(string $headerValue): bool;

    /**
     * @return string[]
     */
    public function getSignatures(): array;
}
