<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace XCart\Service\BotDetector;

class BotDetector implements BotDetectorInterface
{
    public function detectByHeader(string $headerValue): bool
    {
        if (str_contains($headerValue, 'bot')) {
            return true;
        }

        foreach ($this->getSignatures() as $signature) {
            if (str_contains($headerValue, $signature)) {
                return true;
            }
        }

        return false;
    }

    public function getSignatures(): array
    {
        return [
            'ylt',
            '008',
            '01h4x.com',
            '13tabs',
            '192.comagent',
            '2gdpr',
            '2ip.ru',
            '360spider',
            '404checker',
            '404enemy',
            '7siters',
            '80legs',
            'a6-indexer',
            'admantx',
            'ahc',
            'alittle client',
            'apis-google',
            'aspseek',
            'aws security scanner',
            'abonti',
            'aboundex',
            'accoona-ai-agent',
            'acunetix',
            'adauth',
            'addthis',
            'adminlabs',
            'adstxtaggregator',
            'adyen httpclient',
            'aether',
            'affiliatelabz',
            'airmail',
            'akkoma',
            'alibaba.security.heimdall',
            'allsubmitter',
            'alligator',
            'amazon cloudfront',
            'amazon simple notification service agent',
            'amazon-route53-health-check-service',
            'anarchie',
            'anarchy',
            'anarchy99',
            'androiddownloadmanager',
            'anemone',
            'anglesharp',
            'ankit',
            'ant.com',
            'anthill',
            'anturis agent',
            'anyevent-http',
            'apache ant',
            'apache droid',
            'apache openoffice',
            'apache-httpasyncclient',
            'apache-httpclient',
            'apachebench',
            'apexoo',
            'aportworm',
            'appbeat',
            'appengine-google',
            'applesyndication',
            'aprc',
            'arachmo',
            'arachnophilia',
            'arukereso',
            'asana',
            'ask jeeves',
            'askquickly',
            'aspiegel',
            'asterias',
            'astute',
            'astute srm',
            'attach',
            'automaticwptester',
            'autonomy',
            'b-l-i-t-z-b-o-t',
            'bbbike',
            'bcklinks',
            'bdfetch',
            'bkctwitterunshortener',
            'bpimagewalker',
            'btwebclient',
            'bubing',
            'backstreet',
            'backweb',
            'backlink-ceck',
            'backlinkcrawler',
            'backlinkhttpstatus',
            'backupland',
            'bad-neighborhood',
            'badass',
            'baidu',
            'baiduspider',
            'bandit',
            'barkrowler',
            'batchftp',
            'battleztar bazinga',
            'bazqux',
            'begunadvertising',
            'bewica-security-scan',
            'bidtellect',
            'bigbozz',
            'bigfoot',
            'binglocalsearch',
            'bingpreview',
            'bitacle',
            'bitrix link preview',
            'black hole',
            'blackwidow',
            'blackboard',
            'blackboard safeassign',
            'blocknote.net',
            'blogbridge',
            'blogpulselive',
            'blogsearch',
            'bloglines',
            'bloglovin',
            'blogtrottr',
            'blow',
            'blowfish',
            'boardreader',
            'boardreader',
            'bolt',
            'boost.beast',
            'braintree-webhooks',
            'branch metrics api',
            'branch-passthrough',
            'brandverity',
            'brandprotect',
            'brandwatch',
            'brodie',
            'browsershots',
            'buck',
            'buddy',
            'builtwith',
            'bullseye',
            'bunnyslippers',
            'burf search',
            'butterfly',
            'buzzsumo',
            'bytespider',
            'caam',
            'catexplorador',
            'cc metadata scaper',
            'cert.at-statistics-survey',
            'cispa vulnerability notification',
            'cispa web analyser',
            'cjnetworkquality',
            'code87',
            'comodo dcv',
            'cshttp',
            'csscheck',
            'cakephp',
            'calculon',
            'calypso v',
            'canary%20mail',
            'caretnail',
            'cegbfeieh',
            'censysinspect',
            'cerberian drtrs',
            'changesmeter',
            'charlotte',
            'cheteam',
            'checkhost',
            'cherrypicker',
            'chinaclaw',
            'chirp',
            'chlooe',
            'chromaxa',
            'cirrusexplorer',
            'citoid',
            'clarsentia',
            'cloud mapping',
            'cloudendure',
            'cloudflare-alwaysonline',
            'cloudflare speedtest',
            'cloudflare-healthchecks',
            'cloudinary',
            'coldfusion',
            'collector',
            'commafeed',
            'commoncrawler',
            'commoncrawler node',
            'commons-httpclient',
            'contextual code sites explorer',
            'cookiereports',
            'copier',
            'copyrightcheck',
            'copyscape',
            'corax',
            'cosmos',
            'cosmos4j.feedback',
            'covario-ids',
            'craw',
            'crawling at home project',
            'crazywebcrawler',
            'crescent',
            'criteo',
            'crowsnest',
            'cula',
            'curious',
            'curious george',
            'custo',
            'cyotekwebcopy',
            'dapnethttp',
            'dhsh',
            'dmbrowser',
            'dnspod-reporting',
            'dsearch',
            'dts agent',
            'dangdang',
            'dareboost',
            'datacha0s',
            'dataxu',
            'databasedrivermysqli',
            'datadogsynthetics',
            'datafeedwatch',
            'datanyze',
            'dataparksearch',
            'davclnt',
            'demon',
            'deusu',
            'deusu',
            'devil',
            'digg',
            'digincore',
            'digitalpebble',
            'dirbuster',
            'disco',
            'discourse forum onebox',
            'dispatch',
            'disqus',
            'dittospyder',
            'dnbcrawler-analytics',
            'dolphin http client',
            'domainappender',
            'domaincrawler',
            'domainlabz',
            'domainsigmacrawler',
            'domains project',
            'donuts content explorer',
            'down/5',
            'download wonder',
            'downtimedetector',
            'dragonfly',
            'drip',
            'drupal (+http:drupal.org)',
            'duckduckgo',
            'duplexweb-google',
            'dynatracesynthetic',
            'earthcom',
            'eccp',
            'email exractor',
            'email siphon',
            'email wolf',
            'easy-thumb',
            'easydl',
            'ebingbong',
            'ecxi',
            'eirgrabber',
            'electricmonk',
            'emailwolf',
            'embarcadero',
            'embed php library',
            'embedly',
            'erocrawler',
            'eventmachine httpclient',
            'everwall link expander',
            'evidon',
            'evil',
            'evrinid',
            'exactsearch',
            'exaleadcloudview',
            'excel',
            'exorank',
            'expanse',
            'exploratodo',
            'express webpictures',
            'extractor',
            'extractorpro',
            'extreme picture finder',
            'eyenetie',
            'ezooms',
            'fdm',
            'fdm',
            'fhscan',
            'faraday v',
            'fastcrawler',
            'favorg',
            'faveeo',
            'favicon downloader',
            'feed wrangler',
            'feedbooster',
            'feedbucket',
            'feedbunch',
            'feedburner',
            'feedviewer',
            'feedzcollector',
            'feedable',
            'feedbin',
            'feeder',
            'feedfetcher-google',
            'feedly',
            'feedshow',
            'feedshowonline',
            'feedspot',
            'feedwind',
            'fetch',
            'fetch api',
            'fever',
            'fiery%20feeds',
            'filestack',
            'fimap',
            'flashget',
            'flipboardbrowserproxy',
            'flipboardproxy',
            'flipboardrss',
            'flock',
            'florienzh',
            'flunky',
            'forusp',
            'foundseotool',
            'freeuploader',
            'freshrss',
            'friendica',
            'frontpage',
            'funnelback',
            'fuzz',
            'fuzz faster u fool',
            'fyberspider',
            'g-i-g-a-b-o-t',
            'gis-labs',
            'grequests',
            'gt::www',
            'gtmetrix',
            'garlikcrawler',
            'genieo',
            'gentlesource',
            'germcrawler',
            'getcode',
            'getlinkinfo',
            'getright',
            'geturlinfo',
            'getweb',
            'getintent',
            'geziyor',
            'ghost inspector',
            'giant rhubarb',
            'gigablastopensource',
            'github-hookshot',
            'gluten free crawler',
            'go http package',
            'go!zilla',
            'go-ahead-got-it',
            'go-http-client',
            'gospotcheck',
            'gozilla',
            'gofeed',
            'goldfire server',
            'gomezagent',
            'goodzer',
            'google appsviewer',
            'google desktop',
            'google keyword suggestion',
            'google keyword tool',
            'google pp default',
            'google page speed insights',
            'google search console',
            'google web preview',
            'google favicon',
            'google-ads',
            'google-adwords',
            'google-adwords-instant',
            'google-apps-scrip',
            'google-apps-script',
            'google-calendar-importer',
            'google-http-java-client',
            'google-hoteladsverifier',
            'google-inspectiontool',
            'google-podcast',
            'google-publisher-plugin',
            'google-read-aloud',
            'google-smtp-sts',
            'google-searchbyimage',
            'google-site-verification',
            'google-structured-data-testing-tool',
            'google-transparency-report',
            'google-youtube-links',
            'google-speakr',
            'googledocs',
            'googlehc',
            'googleprober',
            'googleproducer',
            'googlesites',
            'gookey',
            'goose',
            'gotit',
            'grabnet',
            'grabber',
            'gradle',
            'grafula',
            'grammarly',
            'grapefx',
            'grapeshotcrawler',
            'greatnews',
            'gregarius',
            'grouphigh',
            'guzzlehttp',
            'haa(a)?rtland http client',
            'headmasterseo',
            'hmview',
            'htmlparser',
            'http banner detection',
            'http-header-abfrage',
            'http-tiny',
            'http::lite',
            'httpclient',
            'httpmon',
            'http_compression_test',
            'http_request2',
            'httpie',
            'httping',
            'httrack',
            'haansoft',
            'hadi agent',
            'haosouspider',
            'happyapps-webcheck',
            'hardenize',
            'harvest',
            'hatena',
            'havij',
            'haxermen',
            'headlesschrome',
            'heartrails_capture',
            'hexometer',
            'hloader',
            'holmes',
            'honesosearchengine',
            'hootsuite image proxy',
            'hootsuite-webfeed',
            'hosttracker',
            'httpcomponents',
            'httpurlconnection',
            'hubspot',
            'hubspot-link-resolver',
            'humanlinks',
            'idbte4m',
            'idg twitter links resolver',
            'idwhois',
            'iodc',
            'ioi',
            'ips',
            'ipworks https component',
            'izabee',
            'iblog',
            'id-search',
            'ideelaborplagiaat',
            'iframely',
            'iltrovatore',
            'image fetch',
            'image sucker',
            'imageengine',
            'imagefetcher',
            'imagevisu',
            'imagga',
            'inagist',
            'indesign%20cc',
            'inboxb0t',
            'indy library',
            'ineturl',
            'infotekies',
            'infowizards reciprocal link',
            'instapaper',
            'integrity',
            'intelliseek',
            'interget',
            'internet ninja',
            'internetseer',
            'iria',
            'irokez',
            'iskanie',
            'jahho',
            'joc web spider',
            'js-kit',
            'jaunt',
            'java',
            'jbrofuzz',
            'jeode',
            'jersey',
            'jetcar',
            'jetslide',
            'jetty',
            'jigsaw',
            'jikespider',
            'jobfeed discovery',
            'jobboerse',
            'jobg8 url monitor',
            'jobrapido',
            'jobsearch1.5',
            'joinvision generic',
            'jolokiapwn',
            'joomla',
            'jorgee',
            'junglekeythumbnail',
            'justview',
            'kocmohabt',
            'kaspersky lab cfr link resolver',
            'kelny',
            'kenjin spider',
            'kerrigan',
            'keycdn',
            'keyword density',
            'keywords research',
            'kickfire',
            'kimonolabs',
            'kinza',
            'kml-google',
            'kraken',
            'kumkie',
            'l.webis',
            'lcc',
            'lnspiderguy',
            'lwp::simple',
            'lyt.sr',
            'larbin',
            'lavf',
            'leap',
            'leechftp',
            'leechget',
            'lftp',
            'libvlc',
            'libweb',
            'libwhisker',
            'licorne',
            'liebaofast',
            'liferea',
            'lighthouse',
            'lightspeedsystems',
            'likse',
            'link valet',
            'linkalarm',
            'linkanalyser',
            'linkexaminer',
            'linkpreview',
            'linkscan',
            'linktiger',
            'linkwalker',
            'linkextractorpro',
            'linksmanager',
            'lipperhey',
            'lipperhey spider',
            'litemage_walker',
            'lmspider',
            'loadimpactrload',
            'longurl api',
            'lucee (cfml engine)',
            'lush http client',
            'mfc_tear_sample',
            'midown tool',
            'miixpc',
            'mqqbrowser',
            'ms web services client protocol',
            'msfrontpage',
            'msiecrawler',
            'mvaclient',
            'macoutlook',
            'mag-net',
            'magnet',
            'magpierss',
            'mail',
            'mail.ru',
            'mail::sts',
            'mailchimp',
            'majestic seo',
            'majestic-seo',
            'majestic12',
            'mandrill',
            'mappercmd',
            'mappy',
            'markmonitor',
            'markwatch',
            'mass downloader',
            'masscan',
            'mastodon',
            'mata hari',
            'maxpointcrawler',
            'mb2345browser',
            'mediametric',
            'mediapartners-google',
            'megaindex',
            'megaindex.ru',
            'meltwaternews',
            'melvil rawi',
            'memgator',
            'metainspector',
            'metauri',
            'metadatascraper',
            'metaspinner',
            'metauri',
            'mget',
            'micromessenger',
            'microsearch',
            'microsoft data access',
            'microsoft office',
            'microsoft outlook',
            'microsoft url control',
            'microsoft windows network diagnostics',
            'microsoft-webdav-miniredir',
            'microsoft.data.mashup',
            'mikrotik',
            'mindjet',
            'minefield',
            'miniature.io',
            'miniflux',
            'miro-httpclient',
            'mister pix',
            'mjukisbyxor',
            'mnogosearch',
            'moblie safari',
            'mojeek',
            'mojolicious',
            'mojolicious (perl)',
            'mollie',
            'montools',
            'monit',
            'monitority',
            'moreover',
            'morfeus fucking scanner',
            'morning paper',
            'movabletype',
            'mozlila',
            'mr.4x3',
            'mr.4x3 powered',
            'mrcgiguy',
            'muckrack',
            'mxtoolbox',
            'netcraft',
            'ng',
            'ng-search',
            'nicerspro',
            'ning',
            'nlnz_iaharvester',
            'nyu',
            'najdi.si',
            'name intelligence',
            'namefo.com',
            'nameprotect',
            'navroad',
            'nearsite',
            'needle',
            'nessus',
            'net vampire',
            'netants',
            'netlyzer',
            'netmechanic',
            'netnewswire',
            'netseer crawler',
            'netshelter contentscan',
            'netspider',
            'netsystemsresearch',
            'nettrack',
            'netzip',
            'netcraft',
            'netcraftsurveyagent',
            'netlab360',
            'netpursual',
            'netsparker',
            'nettrack',
            'netvibes',
            'neustar wpm',
            'neutrinoapi',
            'newrelicpinger',
            'newsblur',
            'newsgator',
            'nexgate ruby client',
            'nibbler',
            'nihilscio',
            'nikto',
            'nimblecrawler',
            'nimbostratus',
            'ninja',
            'nmap',
            'nmap scripting engine',
            'nodeping',
            'nodemeter',
            'norton-safeweb',
            'not',
            'notifixious',
            'notionembedder',
            'nuclei',
            'nutch',
            'nuzzel',
            'nymesis',
            'omsc',
            'oppo a33',
            'observatory',
            'ocelli',
            'octopus',
            'offline explorer',
            'offline navigator',
            'ogscrper',
            'oncrawl',
            'online domain tools',
            'open source rss',
            'opencalaissemanticproxy',
            'openlinkprofiler',
            'openvas',
            'openfind',
            'openstat',
            'openvas',
            'optimizer',
            'orangespider',
            'orbiter',
            'orgprobe',
            'outlook-express',
            'outlook-ios',
            'owler',
            'owlin',
            'oxfordcloudservice',
            'pdf24 url to pdf',
            'pecl::http',
            'php',
            'php-aymapi',
            'php-curl-class',
            'phpcrawl',
            'poe-component-client-http',
            'prtg network monitor',
            'ptst',
            'ptst+',
            'page analyzer',
            'page valet',
            'pageanalyzer',
            'pagefreezer',
            'pagegrabber',
            'pagepeeker',
            'pagescorer',
            'pagething',
            'pagething.com',
            'pagespeed',
            'pandalytics',
            'panopta',
            'panscient',
            'papa foto',
            'pavuk',
            'paypal ipn',
            'pcore-http',
            'pearltrees',
            'peew',
            'peoplepal',
            'percolatecrawler',
            'perlu -',
            'phantomjs',
            'phantomjs screenshoter',
            'photon',
            'pi-monster',
            'picscout',
            'picsearch',
            'picturefinder',
            'piepmatz',
            'pimonster',
            'pingadmin.ru',
            'pingspot',
            'pingability',
            'pingdom',
            'pingoscope',
            'pinterest',
            'pixray',
            'pizilla',
            'plagger',
            'pleasecrawl',
            'pleroma',
            'pleroma',
            'ploetz + zeller',
            'plukkie',
            'pocketimagecache',
            'pocketparser',
            'pockey',
            'podcastaddict',
            'polymail',
            'pompos',
            'porkbun',
            'port monitor',
            'postpost',
            'postmanruntime',
            'powerpoint',
            'prebid',
            'prerender',
            'priceonomics analysis engine',
            'printfriendly',
            'prittorrent',
            'prlog',
            'prowebwalker',
            'probethenet',
            'project ?25499',
            'project-resonance',
            'protopage',
            'pu_in',
            'pulsecrawler',
            'pump',
            'pxbroker',
            'pycurl',
            'python-httplib2',
            'python-urllib',
            'qqdownload',
            'qihoo',
            'qirina hurdler',
            'qrafterpro',
            'qseero',
            'qualidator',
            'queryn metasearch',
            'queryseekerspider',
            'quick-crawler',
            'quiterss',
            'quora link preview',
            'qwantify',
            'r6_commentreader',
            'r6_feedfetcher',
            'rma',
            'roi hunter',
            'rpt-httpclient',
            'rssmix',
            'rssowl',
            'radian6',
            'radiopublicimageresizer',
            'railgun',
            'rankactive',
            'rankflex',
            'ranksonicsiteauditor',
            'rapidload',
            're-re',
            're-re studio',
            'reget',
            'reactornetty',
            'readability',
            'realdownload',
            'realplayer%20downloader',
            'reaper',
            'rebelmouse',
            'recorder',
            'recurpost',
            'redesscrapy',
            'reeder',
            'reederformac',
            'repomonkey',
            'responsecodetest',
            'restsharp',
            'riddler',
            'ripper',
            'rival iq',
            'robosourcer',
            'robozilla',
            'rocketcrawler',
            'ruby|ruby',
            'ryowlengine',
            'sap netweaver application server',
            'sbider',
            'seo browser',
            'seocentro',
            'seokicks',
            'seolizer',
            'seolyticscrawler',
            'seoprofiler',
            'seosearch',
            'seostats',
            'sistrix',
            'sistrix crawler',
            'smrf url expander',
            'smurlexpander',
            'smxcrawler',
            'spdycheck',
            'speng',
            'ssl labs',
            'salesintelligent',
            'saleslift',
            'saucenao',
            'scamadviser-frontend',
            'scanalert',
            'scoop',
            'scopecontentag-http-client',
            'scoutjet',
            'scouturlmonitor',
            'scrapebox page scanner',
            'scrapy',
            'screaming',
            'screenshotservice',
            'scrubby',
            'scrutiny',
            'search37',
            'searchexpress',
            'searchsight',
            'searchwp',
            'searchestate',
            'seeker',
            'seekport',
            'seekport crawler',
            'selfoss',
            'semanticjuice',
            'semiocast http client',
            'semrush',
            'sendsay.ru',
            'seo servis',
            'seocheck',
            'seositecheckup',
            'seobility',
            'seomoz',
            'seznam',
            'shelob',
            'shodan',
            'shopwiki',
            'shoppimon',
            'shortlinktranslate',
            'sideqik',
            'siege',
            'simplepie',
            'simplyfast',
            'siphon',
            'site sucker',
            'site-shot',
            'site24x7',
            'sitebar',
            'sitecheck',
            'sitecondor',
            'siteexplorer',
            'siteguardian',
            'siteindexed',
            'sitelockspider',
            'sitemonitor',
            'sitesnagger',
            'sitesucker',
            'sitetruth',
            'sitebeam',
            'sitebulb',
            'siteimprove',
            'sitemap(s)? generator',
            'sitemapgenerator',
            'siteshooter b0t',
            'sitevigil',
            'skypeuripreview',
            'slack',
            'sleuth',
            'slurp',
            'slysearch',
            'smartdownload',
            'snake',
            'snapsearch',
            'snappy',
            'snarfer',
            'sniffrss',
            'snoopy',
            'snowhaze search',
            'sociscraper',
            'sogou web spider',
            'sortsite',
            'sosospider',
            'sottopop',
            'spacebison',
            'spacecowboys',
            'spamexperts',
            'spammen',
            'spanner',
            'spawning-ai',
            'specificfeeds',
            'speedkit',
            'speedy spider',
            'spiderling',
            'spiderweb',
            'spinn3r',
            'sprinklr',
            'sqlmap',
            'sqlworm',
            'sqworm',
            'stackrambler',
            'statastico',
            'statically-',
            'statuscake',
            'steeler',
            'stormcrawler',
            'stratagems kumo',
            'stripe',
            'stripper',
            'stroke.cz',
            'studiofaca',
            'stumbleupon',
            'sucker',
            'sucuri',
            'superhttp',
            'surphace scout',
            'suzuran',
            'swurl',
            'symfony browserkit',
            'symfony2 browserkit',
            'synhttpclient-built',
            'synapse',
            'syndirella',
            'sysomos',
            'szukacz',
            't0phackteam',
            'tls tester',
            'tlsprobe',
            'ttd-content',
            'tagvisit',
            'tarantula',
            'taringa ugc',
            'tarmotgezgin',
            'teleport',
            'teleportpro',
            'telesoft',
            'telesphoreo',
            'telesphorep',
            'tencenttraveler',
            'tenon.io',
            'teoma',
            'test certificate info',
            'tetrahedron',
            'textrazor downloader',
            'the drop reaper',
            'the expert html source viewer',
            'the intraformant',
            'the knowledge ai',
            'thenomad',
            'thinklab',
            'thumbsniper',
            'thumbor',
            'thumbshots',
            'tineye',
            'tiny tiny rss',
            'titan',
            'toata',
            'traackr.com',
            'tracemyfile',
            'trackuity',
            'trapitagent',
            'trendiction',
            'trendsmap',
            'trendsmapresolver',
            'tryjsoup',
            'tulipchain',
            'turingos',
            'turnitin',
            'tweetminster',
            'tweezler',
            'twice',
            'twikle',
            'twingly',
            'twisted pagegetter',
            'twitterfeed',
            'typhoeus',
            'url verifier',
            'urlemacs',
            'urltester',
            'urlitor',
            'urly warning',
            'urly.warning',
            'udmsearch',
            'universalfeedparser',
            'unshorten.it',
            'untiny',
            'unwindfetchor',
            'upflow',
            'uptimia',
            'urltrends ranking updater',
            'urlcheckr',
            'urlstat',
            'vb project',
            'vci',
            'vsagent',
            'vsb-tuo',
            'vse',
            'vyu2',
            'vacuum',
            'vagabondo',
            'velenpublicwebcrawler',
            'veooz',
            'vericitecrawler',
            'vidiblescraper',
            'virusdie',
            'visual rights group',
            'voideye',
            'voil',
            'voltron',
            'vulnbusters meter',
            'w3c-checklink',
            'w3c-mobileok',
            'w3c_unicorn',
            'wac-ofu',
            'wdt.io',
            'webdav',
            'wepa',
            'wp engine install performance api',
            'wp rocket',
            'wpscan',
            'www-collector-e',
            'www-mechanize',
            'www::document',
            'www::mechanize',
            'wwwoffle',
            'wakeletlinkexpander',
            'wallpapers',
            'wallpapershd',
            'wappalyzer',
            'watchmouse',
            'wbsrch',
            'welikelinks',
            'wesee',
            'web auto',
            'web collage',
            'web enhancer',
            'web fetch',
            'web fuck',
            'web pix',
            'web sauger',
            'web sucker',
            'web spyder',
            'web-sniffer',
            'webauto',
            'webbandit',
            'webcapture',
            'webclient',
            'webcollage',
            'webcookies',
            'webcopier',
            'webcorp',
            'webdatastats',
            'webdoc',
            'webenhancer',
            'webfetch',
            'webfuck',
            'webgazer',
            'webgo is',
            'webimagecollector',
            'webimages',
            'webindex',
            'webleacher',
            'webpix',
            'webreaper',
            'websauger',
            'websniffer',
            'webstripper',
            'websucker',
            'webthumbnail',
            'webwhacker',
            'webzip',
            'webalta',
            'webauskunft',
            'webshag',
            'webshot',
            'website quester',
            'websiteextractor',
            'websitequester',
            'websnapr',
            'webster',
            'webthumb',
            'wfuzz',
            'whack',
            'whacker',
            'whatcms',
            'whatweb',
            'whatsapp',
            'whatsmyip',
            'whatweb',
            'wheregoes?',
            'whibse',
            'whoapi',
            'whorunscoinhive',
            'whynder magnet',
            'widow',
            'winhttp',
            'winhttrack',
            'winhttp-autoproxy-service',
            'winpodder',
            'windows-rss-platform',
            'winds: open source rss & podcast',
            'woko',
            'wolfram httpclient',
            'word',
            'wordpress',
            'wordpress.com',
            'wordpress.com mshots',
            'wordupinfosearch',
            'wotbox',
            'wprecon',
            'wtrace',
            'wukongspider',
            'x-cart catalog generator',
            'x-cart info',
            'xing-contenttabreceiver',
            'xrl',
            'xaldon webspider',
            'xaldon_webspider',
            'xaxissemanticsclassifier',
            'xenforo',
            'xenu',
            'xenu link sleuth',
            'y!j-brw',
            'yp.pl',
            'yaanb',
            'yahoo ad monitoring',
            'yahoo link preview',
            'yahoo! slurp',
            'yahoocachesystem',
            'yahoomailproxy',
            'yahooseeker',
            'yahooysmcm',
            'yandeg',
            'yandex(?!search)',
            'yandeximageresizer',
            'yandeximages',
            'yandexmetrika',
            'yandexvideoparser',
            'yeti',
            'yisouspider',
            'yo-yo',
            'yoys.net',
            'yoleo consumer',
            'yottaamonitor',
            'your-website-sucks',
            'zabbix',
            'zade',
            'zao',
            'zauba',
            'zemanta aggregator',
            'zendhttpclient',
            'zend_http_client',
            'zermelo',
            'zeus',
            'zeus',
            'zmeu',
            'znhttp',
            'znajdzfoto',
            'zombie.js',
            'zoom.mac',
            'zoterotranslationserver',
            'zyborg',
            'a.pr-cy.ru',
            'a3logics.in',
            'aboutthedomain',
            'acebookexternalhit',
            'acoon',
            'acrylicapps.compulp',
            'adbeat',
            'admantx',
            'admantx-adform',
            'adressendeutschland',
            'adreview',
            'adscanner',
            'adstxt-worker',
            'adstxt.com',
            'affilimate-puppeteer',
            'agentslug',
            'aihit',
            'aiohttp',
            'akka-http',
            'akula',
            'alertra',
            'alexa site audit',
            'allloadin',
            'alyze.info',
            'amagit',
            'annotate_google',
            'apimon.de',
            'app.hypefactors.com',
            'arachnode',
            'aria2',
            'arquivo-web-crawler',
            'arquivo.pt',
            'asafaweb',
            'asynchttp',
            'attohttpc',
            'autocite',
            'autoemailspider',
            'awin.com',
            'axios',
            'b0t',
            'backlink-check',
            'baidu',
            'baidu.com',
            'baiduspider',
            'basicstate',
            'baypup',
            'binu image cacher',
            'biglotron',
            'binlar',
            'biz_directory',
            'bluefish',
            'boitho.com-dc',
            'cah.io.community',
            'catexplorador',
            'censys',
            'cf-facebook',
            'cg-eye',
            'changedetection',
            'chatterino-api-cache',
            'check1.exe',
            'checkprivacy',
            'chkme.com',
            'clark-crawler',
            'clips.ua.ac.be',
            'cmcm.com',
            'coccoc',
            'cognitiveseo',
            'colly -',
            'com.plumanalytics',
            'commoncrawl',
            'commonscan',
            'contactbigdatafr',
            'contentkingapp',
            'convera',
            'copyright sheriff',
            'cortex',
            'crawl.sogou.com',
            'crawler.feedback',
            'crawler4j',
            'cs.daum.net',
            'curb',
            'curl',
            'cuwhois',
            'cybo.com',
            'dbpoweramp',
            'dataforseo.com',
            'dataprovider',
            'ddline',
            'deeris',
            'delve.ai',
            'developers.google.com+websnippet',
            'dlvr',
            'dlvr.it',
            'docker',
            'docoloc',
            'domainappender',
            'domainsproject.org',
            'dotmailer content retrieval',
            'dotsemantic',
            'downforeveryoneorjustme',
            'downnotifier',
            'drupact',
            'dubaiindex',
            'ecairn-grabber',
            'ecatch',
            'econtext',
            'ec2linkfinder',
            'elefent',
            'endo',
            'europarchive.org',
            'evc-batch',
            'exif',
            'ezooms',
            'facebookexternalhit',
            'facebookexternalua',
            'facebookplatform',
            'facebookscraper',
            'fairshare',
            'fasthttp',
            'faviconarchive',
            'faviconkit',
            'feeder',
            'feeltiptop',
            'findlink',
            'findthatfile',
            'fluffy',
            'flynxapp',
            'forensiq',
            'fragfinn.de',
            'free thumbnails',
            'frontman',
            'g00g1e.net',
            'gsoap',
            'ganarvisitas',
            'gdnplus.com',
            'geek-tools',
            'genieo',
            'getprismatic',
            'getroot',
            'getstream.io/winds',
            'git',
            'github-camo',
            'github.com',
            'glutenfreepleasure.com',
            'go-mtasts',
            'gobuster',
            'gobyus',
            'gofetch',
            'gooblog',
            'google-xrawler',
            'gopher',
            'gosquared-thumbnailer',
            'grabify',
            'grokkit',
            'grokkit-crawler',
            'grouphigh',
            'grub-client',
            'gvfs',
            'hackney',
            'help@dataminr.com',
            'heritrix',
            'historious',
            'hkedcity',
            'hledejlevne.cz',
            'hosterstats',
            'ht:check',
            'htdig',
            'htmlyse',
            'http-get',
            'http-kit',
            'http-request',
            'http.rb',
            'http:www.neomo.de',
            'httprequest',
            'http_get',
            'http_request2',
            'http_requester',
            'httphr',
            'httpscheck',
            'httpssites_power',
            'httpunit',
            'httrack',
            'huaweisymantec',
            'i2kconnect',
            'igoogleportal',
            'ithemes sync',
            'izsearch',
            'ia_archiver',
            'ibwww-perl',
            'ichiro',
            'idmarch',
            'igdespyder',
            'imagineeasy',
            'imgsizer',
            'inbound.li parser',
            'infegy',
            'infohelfer',
            'inpwrd.com',
            'instabid',
            'integromedb',
            'internetvista monitor',
            'internet_archive',
            'internetwache',
            'intravnews',
            'iplabel',
            'ips-agent',
            'iqdb',
            'isup.li',
            'isitup.org',
            'isitwp.com',
            'iskanie',
            'iubenda-radar',
            'janforman',
            'javelin.io',
            'jobo',
            'khttp',
            'knows.is',
            'kouio',
            'koyu.space',
            'kube-probe',
            'kubectl',
            'kulturarw3',
            'leakix.net',
            'letsencrypt',
            'libwww',
            'libwww-perl',
            'limber.io',
            'link-check',
            'linkcheck',
            'link_thumbnailer',
            'linkdex',
            'linkfluence',
            'linkfluence.com',
            'linkpeek',
            'livedoor screenshot',
            'localsearch-web',
            'longurl-r-package',
            'looid.com',
            'looksystems.net',
            'ltx71',
            'lua-resty-http',
            'lwp-request',
            'lwp-trivial',
            'lycos',
            'mshots',
            'mabontland',
            'magpie-crawler',
            'majestic12',
            'makecontact',
            'marketinggrader',
            'masscan',
            'mattermost',
            'mediawords',
            'metadataparser',
            'metauri.com',
            'mio_httpc',
            'mixdata dot com',
            'mixed-content-scan',
            'mixnode',
            'mogimogi',
            'mon.itor.us',
            'monitis',
            'monitoring-plugins',
            'montastic',
            'mowser',
            'muhstik-scan',
            'myseosnapshot',
            'nwormfeedfinder',
            'nagios',
            'nationalarchives',
            'nbertaupete95',
            'netestate ne crawler',
            'netresearch',
            'nettle',
            'newsblur',
            'newsme',
            'newspaper',
            'nghttp2',
            'nineconnections',
            'node-fetch',
            'node-superagent',
            'node-urllib',
            'node.io',
            'nominet.org.uk',
            'nominet.uk',
            'notifyninja',
            'npm',
            'nuhk',
            'nutch',
            'nyawc',
            'oegp',
            'okhttp',
            'omgili',
            'orion-semantics',
            'ow.ly',
            'owncloud news',
            'page scorer',
            'page2rss',
            'page_verifier',
            'panscient',
            'parsijoo',
            'pcbrowser',
            'peerindex',
            'petalsearch',
            'php-requests',
            'phpservermon',
            'picsearch',
            'ping.blo.gs',
            'pinterest.com',
            'pip',
            'plumanalytics',
            'pnpm',
            'polaris version',
            'postano',
            'postfix-mta-sts-resolver',
            'postplanner.com',
            'postrank',
            'probe-image-size',
            'probethenet',
            'profound',
            'prospectb2b',
            'protopage',
            'proximic',
            'pshtt, https scanning',
            'python-httpx',
            'python-requests',
            'queuedriver',
            'quic-go-http',
            'redback',
            'request.js',
            'reqwest',
            'ripz',
            's1z.ru',
            'safe-agent-scanner',
            'satoristudio.net',
            'sc-downloader',
            'scalaj-http',
            'scan.lol',
            'schmorp.de',
            'scooter',
            'search.thunderstone',
            'searchenginepromotionhelp',
            'searchmetrics',
            'semantic-visions.com',
            'semanticdiscovery',
            'semanticjuice',
            'semrush.com',
            'sentry',
            'seo-nastroj.cz',
            'seo4ajax',
            'seobility',
            'seocompany',
            'seocompany.store',
            'seoscanners',
            'seositecheckup',
            'seostar',
            'servernfo',
            'sexsearcher',
            'shorturl lengthener',
            'shrinktheweb',
            'sindresorhus/got',
            'sitechecker.pro',
            'siteripz',
            'sitexy.com',
            'sli-systems.com',
            'slider.com',
            'slurp',
            'sniptracker',
            'sogou web',
            'sogouspider',
            'sovereign.ai',
            'spaziodati',
            'special_archiver',
            'speedy',
            'spinn3r',
            'spray-can',
            'spyfu',
            'spyonweb',
            'sqlmap',
            'ssl-tools',
            'suchen',
            'summify',
            'superfeedr',
            'swcd',
            'sysomos.com',
            'sysscan',
            'takeout',
            'tchelebi.io',
            'techiaith.cymru',
            'techinfo@ubermetrics-technologies.com',
            'teoma',
            'terrainformatica',
            'terrykyleseoagency.com',
            'testuri',
            'theinternetrules',
            'timewe.net',
            'topster',
            'touche.com',
            'tracemyfile',
            'trendiction',
            'trendiction.com',
            'trendiction.de',
            'trendspottr',
            'truwogps',
            'tweetedtimes',
            'twibble',
            'twine',
            'ubermetrics',
            'ubermetrics-technologies',
            'ubermetrics-technologies.com',
            'uclassify',
            'ultimate_sitemap_parser',
            'unchaos',
            'unirest-java',
            'unshortenit',
            'updated',
            'updown.io daemon',
            'updown_tester',
            'ureq',
            'urlresolver',
            'vbseo',
            'via ggpht.com googleimageproxy',
            'visionutils',
            'vkshare',
            'voltron',
            'voyager',
            'voyagerx.com',
            'w3af.org',
            'wangling',
            'web-capture.net',
            'webcollage',
            'webdatastats.com',
            'webkit2png',
            'webmastercoffee',
            'webmeup-crawler',
            'webmon',
            'webpros.com',
            'webscreenie',
            'websitepulse agent',
            'webtech',
            'wf84',
            'wget',
            'wkhtmlto',
            'wmtips',
            'woorankreview',
            'worldping-api',
            'wotbox',
            'wp_is_mobile',
            'wpif',
            'wprecon.com survey',
            'wscheck',
            'www.monitor.us',
            'x09mozilla',
            'x22mozilla',
            'xpymep1.exe',
            'yacy',
            'yanga',
            'yeti',
            'yomins.com',
            'yooglifetchagent',
            'yourls.org',
            'zauba.io',
            'zgrab'
        ];
    }
}
