<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Security\Http\EventListener;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\Security\Core\Exception\BadCredentialsException;
use Symfony\Component\Security\Http\Authenticator\Passport\Credentials\PasswordCredentials;
use Symfony\Component\Security\Http\Authenticator\Passport\UserPassportInterface;
use Symfony\Component\Security\Http\Event\CheckPassportEvent;
use XCart\Security\Core\Exception\Builder\LoginIsLockedExceptionBuilderInterface;
use XLite\Core\Auth;

class CheckCredentialsListenerDecorator implements EventSubscriberInterface
{
    public function __construct(
        private EventSubscriberInterface $inner,
        private LoginIsLockedExceptionBuilderInterface $loginIsLockedExceptionBuilder,
    ) {
    }

    public function checkPassport(CheckPassportEvent $event): void
    {
        $passport = $event->getPassport();
        if ($passport instanceof UserPassportInterface && $passport->hasBadge(PasswordCredentials::class)) {
            $user = $passport->getUser();

            /** @var \XLite\Model\Profile $profile */
            $profile = $user->getWrappedProfile();

            if (Auth::getInstance()->hasLoginLock($profile)) {
                throw $this->loginIsLockedExceptionBuilder->build();
            }

            try {
                $this->inner->checkPassport($event);
                $profile->setCountOfLoginAttempts(0);
            } catch (BadCredentialsException $e) {
                Auth::getInstance()->processFailedLogin($profile);

                throw $e;
            }
        } else {
            $this->inner->checkPassport($event);
        }
    }

    public static function getSubscribedEvents(): array
    {
        return [CheckPassportEvent::class => 'checkPassport'];
    }
}
