<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Security\Http\Authenticator;

use Symfony\Component\HttpFoundation\Request;
use XCart\Security\Http\Authenticator\TokenRepository\TokenRepositoryInterface;

final class TokenRepositoryFactory
{
    public function __construct(
        private TokenRepositoryInterface $restApiTokenRepository,
        private TokenRepositoryInterface $storefrontApiTokenRepository
    ) {
    }

    public function getTokenRepository(Request $request): TokenRepositoryInterface
    {
        return \str_starts_with($request->getPathInfo(), '/api/storefront')
            ? $this->storefrontApiTokenRepository
            : $this->restApiTokenRepository;
    }
}
