<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Security\Http\Authenticator\TokenRepository;

use Symfony\Component\Security\Core\User\InMemoryUser;
use Symfony\Component\Security\Core\User\UserInterface;
use XLite\Model\Config;

final class StorefrontApiTokenRepository implements TokenRepositoryInterface
{
    private array $tokens;

    public function __construct(
        private \XLite\Model\Repo\Config $configRepository
    ) {
        $this->tokens = \Includes\Utils\ConfigParser::getOptions(['storefront_api', 'additional_storefront_api_keys']);
        $this->tokens[] = $this->getStorefrontApiToken();
    }

    private function getStorefrontApiToken(): ?string
    {
        /** @var Config $param */
        $param = $this->configRepository->findOneBy(['category' => 'API', 'name' => 'storefront_token']);

        return $param?->getValue();
    }

    public function getUserByToken(string $token): ?UserInterface
    {
        if ($token && \in_array($token, $this->tokens, true)) {
            return new InMemoryUser('read_only', null, ['ROLE_USER']);
        }

        return null;
    }
}
