<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Security\DTO;

use XLite\Core\Auth;
use XLite\Core\Database;
use XLite\Model\Role;

final class WebUser extends User
{
    /**
     * @return string[]
     */
    public function getRoles(): array
    {
        if (!$this->profile) {
            return [];
        }

        $userRoles = [];

        /** @var Role $role */
        foreach ($this->profile->getRoles() as $role) {
            /** @var Role\Permission $permission */
            foreach ($role->getPermissions() as $permission) {
                $userRoles[] = $permission->getCode();
            }
        }

        if (in_array(Role\Permission::ROOT_ACCESS, $userRoles, true)) {
            $userRoles = Database::getRepo(Role\Permission::class)?->findAll() ?? [];
            $userRoles = array_map(static function (Role\Permission $permission) {
                return $permission->getCode();
            }, $userRoles);
        }

        $userRoles[] = 'ROLE_USER';
        if ($this->profile->getAccessLevel() === Auth::getInstance()->getAdminAccessLevel()) {
            $userRoles[] = 'ROLE_ADMIN';
        }

        return $userRoles;
    }
}
