<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Security\Core\Exception;

use Symfony\Component\Security\Core\Exception\AuthenticationException;

class LoginIsLockedException extends AuthenticationException
{
    private int $lockLoginDuration;

    public function setLockLoginDuration(int $lockLoginDuration): void
    {
        $this->lockLoginDuration = $lockLoginDuration;
    }

    /**
     * @return string
     */
    public function getMessageKey()
    {
        return sprintf(
            'Login is locked for %d minutes due to too many failed login attempts.',
            (int) ($this->lockLoginDuration / 60)
        );
    }
}
