<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Security\Core\Exception\Builder;

use XCart\Domain\StaticConfigDomain;
use XCart\Security\Core\Exception\LoginIsLockedException;

class LoginIsLockedExceptionBuilder implements LoginIsLockedExceptionBuilderInterface
{
    public function __construct(
        private StaticConfigDomain $staticConfigDomain
    ) {
    }

    public function build(): LoginIsLockedException
    {
        $config = $this->staticConfigDomain->getConfig();

        $exception = new LoginIsLockedException('', 423);
        $exception->setLockLoginDuration(
            (int) $config['authentication']['lock_login_duration']
        );

        return $exception;
    }
}
