<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Repository;

use DateTimeImmutable;
use DateTimeInterface;
use Gesdinet\JWTRefreshTokenBundle\Entity\RefreshToken;

trait RefreshTokenTrait
{
    /**
     * @param DateTimeInterface|null $datetime
     *
     * @return RefreshToken[]
     */
    public function findInvalid($datetime = null)
    {
        $datetime = $datetime ?? new DateTimeImmutable();

        return $this->createQueryBuilder('entity')
            ->where('entity.valid < :datetime')
            ->setParameter(':datetime', $datetime)
            ->getResult();
    }
}
