<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Payment\URLGenerator;

use XLite\Model\Payment\Transaction;

interface URLGeneratorInterface
{
    public const RETURN_TXN_ID = \XLite\Model\Payment\Base\Online::RETURN_TXN_ID;

    public function generateReturnURL(Transaction $transaction, string $fieldName = '', bool $includeId = false): string;

    public function generateCancelURL(Transaction $transaction, string $fieldName = '', bool $includeId = false): string;

    public function generateCallbackURL(Transaction $transaction, string $fieldName = '', bool $includeId = false): string;
}
