<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Payment\URLGenerator;

use XLite\Model\Payment\Transaction;

class FrontendURLGenerator implements URLGeneratorInterface
{
    private string $base = '';

    public function generateReturnURL(Transaction $transaction, string $fieldName = '', bool $includeId = false): string
    {
        $params = [
            'txn_id_name' => $fieldName ?: self::RETURN_TXN_ID,
        ];

        if ($includeId) {
            $params[$params['txn_id_name']] = $transaction->getPublicTxnId();
        }

        $params['action'] = 'return';

        return $this->generateURL($params);
    }

    public function generateCancelURL(Transaction $transaction, string $fieldName = '', bool $includeId = false): string
    {
        $params = [
            'txn_id_name' => $fieldName ?: self::RETURN_TXN_ID,
        ];

        if ($includeId) {
            $params[$params['txn_id_name']] = $transaction->getPublicTxnId();
        }

        $params['cancel'] = 1;

        $params['action'] = 'cancel';

        return $this->generateURL($params);
    }

    public function generateCallbackURL(Transaction $transaction, string $fieldName = '', bool $includeId = false): string
    {
        $params = [
            'txn_id_name' => $fieldName ?: self::RETURN_TXN_ID,
        ];

        if ($includeId) {
            $params[$params['txn_id_name']] = $transaction->getPublicTxnId();
        }

        $params['action'] = 'callback';

        return $this->generateURL($params);
    }

    public function getBase(): string
    {
        return $this->base;
    }

    public function setBase(string $base): self
    {
        $this->base = $base;

        return $this;
    }

    private function generateURL(array $params): string
    {
        return $this->base . '?' . http_build_query($params);
    }
}
