<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace XCart\Payment\URLGenerator;

use XLite\Model\Payment\Transaction;

class BackendURLGenerator implements URLGeneratorInterface
{
    public function generateReturnURL(Transaction $transaction, string $fieldName = '', bool $includeId = false): string
    {
        $params = [
            'txn_id_name' => $fieldName ?: self::RETURN_TXN_ID,
        ];

        if ($includeId) {
            $params[$params['txn_id_name']] = $transaction->getPublicTxnId();
        }

        $params['cancel'] = 1;

        return $this->generateURL('payment_return', '', $params);
    }

    public function generateCancelURL(Transaction $transaction, string $fieldName = '', bool $includeId = false): string
    {
        $params = [
            'txn_id_name' => $fieldName ?: self::RETURN_TXN_ID,
        ];

        if ($includeId) {
            $params[$params['txn_id_name']] = $transaction->getPublicTxnId();
        }

        $params['cancel'] = 1;

        return $this->generateURL('payment_return', '', $params);
    }

    public function generateCallbackURL(Transaction $transaction, string $fieldName = '', bool $includeId = false): string
    {
        $params = [
            'txn_id_name' => $fieldName ?: self::RETURN_TXN_ID,
        ];

        if ($includeId) {
            $params[$params['txn_id_name']] = $transaction->getPublicTxnId();
        }

        return $this->generateURL('callback', '', $params);
    }

    private function generateURL(string $target, string $action, array $params): string
    {
        return \XLite\Core\URLManager::getShopURL(
            \XLite\Core\Converter::buildURL($target, $action, $params, \XLite::getCustomerScript()),
            \XLite\Core\Config::getInstance()->Security->customer_security
        );
    }
}
